#ifndef NOSTYPE_H
#define NOSTYPE_H

// nostypes.h
#include <stdio.h>

#include "nugget/app/avb/avb.pb.h"
#include "nugget/app/identity/identity.pb.h"
#include "nugget/app/keymaster/keymaster.pb.h"
#include "nugget/app/weaver/weaver.pb.h"

using namespace google::protobuf;
using namespace std;

namespace nostypes {
/* Commands declarations */
enum WeaverCmdsId { GetConfig, Write, Read };
enum KeymasterCmdsId {
  AddRngEntropy,
  GenerateKey,
  GetKeyCharacteristics,
  ImportKey,
  ExportKey,
  StartAttestKey,
  UpgradeKey,
  DeleteKey,
  DeleteAllKeys,
  DestroyAttestationIds,
  BeginOperation,
  UpdateOperation,
  FinishOperation,
  AbortOperation,
  ImportWrappedKey,
  SetRootOfTrust,
  SetBootState,
  ProvisionDeviceIds,
  ReadTeeBatchCertificate,
  GetHmacSharingParameters,
  ComputeSharedHmac,
  DTupHandshake,
  DTupFetchInputEvent,
  SetSystemVersionInfo,
  GetBootInfo,
  ProvisionPresharedSecret,
  ContinueAttestKey,
  FinishAttestKey,
  ProvisionCertificates,
  DeviceLocked,
  EarlyBootEnded,
  ReadCertificate,
  IdentityStartAttestKey,
  IdentityFinishAttestKey,
  VigoReadVS,
  VigoStartChannel,
  VigoStoreSecret,
  VigoReleaseSecret,
};

enum AVBCmdsId {
  GetState,
  Load,
  Store,
  GetLock,
  CarrierLock,
  CarrierUnlock,
  SetDeviceLock,
  SetBootLock,
  SetOwnerLock,
  SetProduction,
  CarrierLockTest,
  Reset,
  BootloaderDone,
  GetOwnerKey,
  GetResetChallenge,
  ProductionResetTest,
};

enum IdentityCmdsId {
  WICinitialize,
  WICcreateCredentialKey,
  WICstartPersonalization,
  WICaddAccessControlProfile,
  WICbeginAddEntry,
  WICaddEntryValue,
  WICfinishAddingEntries,
  ICinitialize,
  ICcreateEphemeralKeyPair,
  ICgenerateSigningKeyPair,
  ICcreateAuthChallenge,
  ICstartRetrieveEntries,
  ICsetAuthToken,
  ICpushReaderCert,
  ICvalidateAccessControlProfile,
  ICvalidateRequestMessage,
  ICcalcMacKey,
  ICstartRetrieveEntryValue,
  ICretrieveEntryValue,
  ICfinishRetrieval,
  ICdeleteCredential
};

class NosCmd {
 public:
  string name;
  int id;
  Message *request;
  Message *reply;

  NosCmd();
  NosCmd(int id, string name, Message *request, Message *reply);
  bool isNameSame(string name) const;
};

/* App declarations */
enum App { Nugget, AVB, Keymaster, Weaver, Identity = 5 };

class NosApp {
 public:
  string name;
  int id;
  std::map<int, NosCmd> cmds;
  NosApp(int id, string name, std::map<int, NosCmd> cmds);
  bool isNameSame(string name) const;
  const NosCmd *findNosCmdByName(string name) const;
  static const NosApp *findNosAppByName(string name);
  void printCmdList() const;
};

/* NosTypes declaration */

/* Commands declaration */
/* AVB commands declaration */
inline std::map<int, NosCmd> avbCmds = {
    {AVBCmdsId::GetState, NosCmd(AVBCmdsId::GetState, string("GetState"),
                                 new nugget::app::avb::GetStateRequest(),
                                 new nugget::app::avb::GetStateResponse())},
    {AVBCmdsId::Load, NosCmd(AVBCmdsId::Load, string("Load"),
                             new nugget::app::avb::LoadRequest(),
                             new nugget::app::avb::LoadResponse())},
    {AVBCmdsId::Store, NosCmd(AVBCmdsId::Store, string("Store"),
                              new nugget::app::avb::StoreRequest(),
                              new nugget::app::avb::StoreResponse())},
    {AVBCmdsId::GetLock, NosCmd(AVBCmdsId::GetLock, string("GetLock"),
                                new nugget::app::avb::GetLockRequest(),
                                new nugget::app::avb::GetLockResponse())},
    {AVBCmdsId::CarrierLock,
     NosCmd(AVBCmdsId::CarrierLock, string("CarrierLock"),
            new ::nugget::app::avb::CarrierLockRequest(),
            new ::nugget::app::avb::CarrierLockResponse())},
    {AVBCmdsId::CarrierUnlock,
     NosCmd(AVBCmdsId::CarrierUnlock, string("CarrierUnlock"),
            new ::nugget::app::avb::CarrierUnlockRequest(),
            new ::nugget::app::avb::CarrierUnlockResponse())},
    {AVBCmdsId::SetDeviceLock,
     NosCmd(AVBCmdsId::SetDeviceLock, string("SetDeviceLock"),
            new ::nugget::app::avb::SetDeviceLockRequest(),
            new ::nugget::app::avb::SetDeviceLockResponse())},
    {AVBCmdsId::SetBootLock,
     NosCmd(AVBCmdsId::SetBootLock, string("SetBootLock"),
            new ::nugget::app::avb::SetBootLockRequest(),
            new ::nugget::app::avb::SetBootLockResponse())},
    {AVBCmdsId::SetOwnerLock,
     NosCmd(AVBCmdsId::SetOwnerLock, string("SetOwnerLock"),
            new ::nugget::app::avb::SetOwnerLockRequest(),
            new ::nugget::app::avb::SetOwnerLockResponse())},
    {AVBCmdsId::SetProduction,
     NosCmd(AVBCmdsId::SetProduction, string("SetProduction"),
            new ::nugget::app::avb::SetProductionRequest(),
            new ::nugget::app::avb::SetProductionResponse())},
    {AVBCmdsId::CarrierLockTest,
     NosCmd(AVBCmdsId::CarrierLockTest, string("CarrierLockTest"),
            new ::nugget::app::avb::CarrierLockTestRequest(),
            new ::nugget::app::avb::CarrierLockTestResponse())},
    {AVBCmdsId::Reset, NosCmd(AVBCmdsId::Reset, string("Reset"),
                              new ::nugget::app::avb::ResetRequest(),
                              new ::nugget::app::avb::ResetResponse())},
    {AVBCmdsId::BootloaderDone,
     NosCmd(AVBCmdsId::BootloaderDone, string("BootloaderDone"),
            new nugget::app::avb::BootloaderDoneRequest(),
            new nugget::app::avb::BootloaderDoneResponse())},
    {AVBCmdsId::GetOwnerKey,
     NosCmd(AVBCmdsId::GetOwnerKey, string("GetOwnerKey"),
            new ::nugget::app::avb::GetOwnerKeyRequest(),
            new ::nugget::app::avb::GetOwnerKeyResponse())},
    {AVBCmdsId::GetResetChallenge,
     NosCmd(AVBCmdsId::GetResetChallenge, string("GetResetChallenge"),
            new ::nugget::app::avb::GetResetChallengeRequest(),
            new ::nugget::app::avb::GetResetChallengeResponse())},
    {AVBCmdsId::ProductionResetTest,
     NosCmd(AVBCmdsId::ProductionResetTest, string("ProductionResetTest"),
            new ::nugget::app::avb::ProductionResetTestRequest(),
            new ::nugget::app::avb::ProductionResetTestResponse())},
};

/* Keymaster commands declaration */
inline std::map<int, NosCmd> keymasterCmds = {
    {KeymasterCmdsId::AddRngEntropy,
     NosCmd(KeymasterCmdsId::AddRngEntropy, string("AddRngEntropy"),
            new ::nugget::app::keymaster::AddRngEntropyRequest(),
            new ::nugget::app::keymaster::AddRngEntropyResponse())},
    {KeymasterCmdsId::GenerateKey,
     NosCmd(KeymasterCmdsId::GenerateKey, string("GenerateKey"),
            new ::nugget::app::keymaster::GenerateKeyRequest(),
            new ::nugget::app::keymaster::GenerateKeyResponse())},
    {KeymasterCmdsId::GetKeyCharacteristics,
     NosCmd(KeymasterCmdsId::GetKeyCharacteristics,
            string("GetKeyCharacteristics"),
            new ::nugget::app::keymaster::GetKeyCharacteristicsRequest(),
            new ::nugget::app::keymaster::GetKeyCharacteristicsResponse())},
    {KeymasterCmdsId::ImportKey,
     NosCmd(KeymasterCmdsId::ImportKey, string("ImportKey"),
            new ::nugget::app::keymaster::ImportKeyRequest(),
            new ::nugget::app::keymaster::ImportKeyResponse())},
    {KeymasterCmdsId::ExportKey,
     NosCmd(KeymasterCmdsId::ExportKey, string("ExportKey"),
            new ::nugget::app::keymaster::ExportKeyRequest(),
            new ::nugget::app::keymaster::ExportKeyResponse())},
    {KeymasterCmdsId::StartAttestKey,
     NosCmd(KeymasterCmdsId::StartAttestKey, string("StartAttestKey"),
            new ::nugget::app::keymaster::StartAttestKeyRequest(),
            new ::nugget::app::keymaster::StartAttestKeyResponse())},
    {KeymasterCmdsId::UpgradeKey,
     NosCmd(KeymasterCmdsId::UpgradeKey, string("UpgradeKey"),
            new ::nugget::app::keymaster::UpgradeKeyRequest(),
            new ::nugget::app::keymaster::UpgradeKeyResponse())},
    {KeymasterCmdsId::DeleteKey,
     NosCmd(KeymasterCmdsId::DeleteKey, string("DeleteKey"),
            new ::nugget::app::keymaster::DeleteKeyRequest(),
            new ::nugget::app::keymaster::DeleteKeyResponse())},
    {KeymasterCmdsId::DeleteAllKeys,
     NosCmd(KeymasterCmdsId::DeleteAllKeys, string("DeleteAllKeys"),
            new ::nugget::app::keymaster::DeleteAllKeysRequest(),
            new ::nugget::app::keymaster::DeleteAllKeysResponse())},
    {KeymasterCmdsId::DestroyAttestationIds,
     NosCmd(KeymasterCmdsId::DestroyAttestationIds,
            string("DestroyAttestationIds"),
            new ::nugget::app::keymaster::DestroyAttestationIdsRequest(),
            new ::nugget::app::keymaster::DestroyAttestationIdsResponse())},
    {KeymasterCmdsId::BeginOperation,
     NosCmd(KeymasterCmdsId::BeginOperation, string("BeginOperation"),
            new ::nugget::app::keymaster::BeginOperationRequest(),
            new ::nugget::app::keymaster::BeginOperationResponse())},
    {KeymasterCmdsId::UpdateOperation,
     NosCmd(KeymasterCmdsId::UpdateOperation, string("UpdateOperation"),
            new ::nugget::app::keymaster::UpdateOperationRequest(),
            new ::nugget::app::keymaster::UpdateOperationResponse())},
    {KeymasterCmdsId::FinishOperation,
     NosCmd(KeymasterCmdsId::FinishOperation, string("FinishOperation"),
            new ::nugget::app::keymaster::FinishOperationRequest(),
            new ::nugget::app::keymaster::FinishOperationResponse())},
    {KeymasterCmdsId::AbortOperation,
     NosCmd(KeymasterCmdsId::AbortOperation, string("AbortOperation"),
            new ::nugget::app::keymaster::AbortOperationRequest(),
            new ::nugget::app::keymaster::AbortOperationResponse())},
    {KeymasterCmdsId::ImportWrappedKey,
     NosCmd(KeymasterCmdsId::ImportWrappedKey, string("ImportWrappedKey"),
            new ::nugget::app::keymaster::ImportWrappedKeyRequest(),
            new ::nugget::app::keymaster::ImportKeyResponse())},
    {KeymasterCmdsId::SetRootOfTrust,
     NosCmd(KeymasterCmdsId::SetRootOfTrust, string("SetRootOfTrust"),
            new ::nugget::app::keymaster::SetRootOfTrustRequest(),
            new ::nugget::app::keymaster::SetRootOfTrustResponse())},
    {KeymasterCmdsId::SetBootState,
     NosCmd(KeymasterCmdsId::SetBootState, string("SetBootState"),
            new ::nugget::app::keymaster::SetBootStateRequest(),
            new ::nugget::app::keymaster::SetBootStateResponse())},
    {KeymasterCmdsId::ProvisionDeviceIds,
     NosCmd(KeymasterCmdsId::ProvisionDeviceIds, string("ProvisionDeviceIds"),
            new ::nugget::app::keymaster::ProvisionDeviceIdsRequest(),
            new ::nugget::app::keymaster::ProvisionDeviceIdsResponse())},
    {KeymasterCmdsId::ReadTeeBatchCertificate,
     NosCmd(KeymasterCmdsId::ReadTeeBatchCertificate,
            string("ReadTeeBatchCertificate"),
            new ::nugget::app::keymaster::ReadTeeBatchCertificateRequest(),
            new ::nugget::app::keymaster::ReadTeeBatchCertificateResponse())},
    {KeymasterCmdsId::GetHmacSharingParameters,
     NosCmd(KeymasterCmdsId::GetHmacSharingParameters,
            string("GetHmacSharingParameters"),
            new ::nugget::app::keymaster::GetHmacSharingParametersRequest(),
            new ::nugget::app::keymaster::GetHmacSharingParametersResponse())},
    {KeymasterCmdsId::ComputeSharedHmac,
     NosCmd(KeymasterCmdsId::ComputeSharedHmac, string("ComputeSharedHmac"),
            new ::nugget::app::keymaster::ComputeSharedHmacRequest(),
            new ::nugget::app::keymaster::ComputeSharedHmacResponse())},
    {KeymasterCmdsId::DTupHandshake,
     NosCmd(KeymasterCmdsId::DTupHandshake, string("DTupHandshake"),
            new ::nugget::app::keymaster::DTupHandshakeRequest(),
            new ::nugget::app::keymaster::DTupHandshakeResponse())},
    {KeymasterCmdsId::DTupFetchInputEvent,
     NosCmd(KeymasterCmdsId::DTupFetchInputEvent, string("DTupFetchInputEvent"),
            new ::nugget::app::keymaster::DTupFetchInputEventRequest(),
            new ::nugget::app::keymaster::DTupFetchInputEventResponse())},
    {KeymasterCmdsId::SetSystemVersionInfo,
     NosCmd(KeymasterCmdsId::SetSystemVersionInfo,
            string("SetSystemVersionInfo"),
            new ::nugget::app::keymaster::SetSystemVersionInfoRequest(),
            new ::nugget::app::keymaster::SetSystemVersionInfoResponse())},
    {KeymasterCmdsId::GetBootInfo,
     NosCmd(KeymasterCmdsId::GetBootInfo, string("GetBootInfo"),
            new ::nugget::app::keymaster::GetBootInfoRequest(),
            new ::nugget::app::keymaster::GetBootInfoResponse())},
    {KeymasterCmdsId::ProvisionPresharedSecret,
     NosCmd(KeymasterCmdsId::ProvisionPresharedSecret,
            string("ProvisionPresharedSecret"),
            new ::nugget::app::keymaster::ProvisionPresharedSecretRequest(),
            new ::nugget::app::keymaster::ProvisionPresharedSecretResponse())},
    {KeymasterCmdsId::ContinueAttestKey,
     NosCmd(KeymasterCmdsId::ContinueAttestKey, string("ContinueAttestKey"),
            new ::nugget::app::keymaster::ContinueAttestKeyRequest(),
            new ::nugget::app::keymaster::ContinueAttestKeyResponse())},
    {KeymasterCmdsId::FinishAttestKey,
     NosCmd(KeymasterCmdsId::FinishAttestKey, string("FinishAttestKey"),
            new ::nugget::app::keymaster::FinishAttestKeyRequest(),
            new ::nugget::app::keymaster::FinishAttestKeyResponse())},
    {KeymasterCmdsId::ProvisionCertificates,
     NosCmd(KeymasterCmdsId::ProvisionCertificates,
            string("ProvisionCertificates"),
            new ::nugget::app::keymaster::ProvisionCertificatesRequest(),
            new ::nugget::app::keymaster::ProvisionCertificatesResponse())},
    {KeymasterCmdsId::DeviceLocked,
     NosCmd(KeymasterCmdsId::DeviceLocked, string("DeviceLocked"),
            new ::nugget::app::keymaster::DeviceLockedRequest(),
            new ::nugget::app::keymaster::DeviceLockedResponse())},
    {KeymasterCmdsId::EarlyBootEnded,
     NosCmd(KeymasterCmdsId::EarlyBootEnded, string("EarlyBootEnded"),
            new ::nugget::app::keymaster::EarlyBootEndedRequest(),
            new ::nugget::app::keymaster::EarlyBootEndedResponse())},
    {KeymasterCmdsId::ReadCertificate,
     NosCmd(KeymasterCmdsId::ReadCertificate, string("ReadCertificate"),
            new ::nugget::app::keymaster::ReadCertificateRequest(),
            new ::nugget::app::keymaster::ReadCertificateResponse())},
    {KeymasterCmdsId::IdentityStartAttestKey,
     NosCmd(KeymasterCmdsId::IdentityStartAttestKey,
            string("IdentityStartAttestKey"),
            new ::nugget::app::keymaster::IdentityStartAttestKeyRequest(),
            new ::nugget::app::keymaster::IdentityStartAttestKeyResponse())},
    {KeymasterCmdsId::IdentityFinishAttestKey,
     NosCmd(KeymasterCmdsId::IdentityFinishAttestKey,
            string("IdentityFinishAttestKey"),
            new ::nugget::app::keymaster::IdentityFinishAttestKeyRequest(),
            new ::nugget::app::keymaster::IdentityFinishAttestKeyResponse())},
    {KeymasterCmdsId::VigoReadVS,
     NosCmd(KeymasterCmdsId::VigoReadVS, string("VigoReadVS"),
            new ::nugget::app::keymaster::VigoReadVSRequest(),
            new ::nugget::app::keymaster::VigoReadVSResponse())},
    {KeymasterCmdsId::VigoStartChannel,
     NosCmd(KeymasterCmdsId::VigoStartChannel, string("VigoStartChannel"),
            new ::nugget::app::keymaster::VigoStartChannelRequest(),
            new ::nugget::app::keymaster::VigoStartChannelResponse())},
    {KeymasterCmdsId::VigoStoreSecret,
     NosCmd(KeymasterCmdsId::VigoStoreSecret, string("VigoStoreSecret"),
            new ::nugget::app::keymaster::VigoStoreSecretRequest(),
            new ::nugget::app::keymaster::VigoStoreSecretResponse())},
    {KeymasterCmdsId::VigoReleaseSecret,
     NosCmd(KeymasterCmdsId::VigoReleaseSecret, string("VigoReleaseSecret"),
            new ::nugget::app::keymaster::VigoReleaseSecretRequest(),
            new ::nugget::app::keymaster::VigoReleaseSecretResponse())},
};

/* Weaver commands declaration */
inline std::map<int, NosCmd> weaverCmds = {
    {WeaverCmdsId::GetConfig,
     NosCmd(WeaverCmdsId::GetConfig, string("GetConfig"),
            new nugget::app::weaver::GetConfigRequest(),
            new nugget::app::weaver::GetConfigResponse())},
    {WeaverCmdsId::Write, NosCmd(WeaverCmdsId::Write, string("Write"),
                                 new nugget::app::weaver::WriteRequest(),
                                 new nugget::app::weaver::WriteResponse())},
    {WeaverCmdsId::Read, NosCmd(WeaverCmdsId::Read, string("Read"),
                                new nugget::app::weaver::ReadRequest(),
                                new nugget::app::weaver::ReadResponse())},
};

/* Identity commands declaration */
inline std::map<int, NosCmd> identityCmds = {
    {IdentityCmdsId::WICinitialize,
     NosCmd(IdentityCmdsId::WICinitialize, string("WICinitialize"),
            new nugget::app::identity::WICinitializeRequest(),
            new nugget::app::identity::WICinitializeResponse())},
    {IdentityCmdsId::WICcreateCredentialKey,
     NosCmd(IdentityCmdsId::WICcreateCredentialKey,
            string("WICcreateCredentialKey"),
            new nugget::app::identity::WICcreateCredentialKeyRequest(),
            new nugget::app::identity::WICcreateCredentialKeyResponse())},
    {IdentityCmdsId::WICstartPersonalization,
     NosCmd(IdentityCmdsId::WICstartPersonalization,
            string("WICstartPersonalization"),
            new nugget::app::identity::WICstartPersonalizationRequest(),
            new nugget::app::identity::WICstartPersonalizationResponse())},
    {IdentityCmdsId::WICaddAccessControlProfile,
     NosCmd(IdentityCmdsId::WICaddAccessControlProfile,
            string("WICaddAccessControlProfile"),
            new nugget::app::identity::WICaddAccessControlProfileRequest(),
            new nugget::app::identity::WICaddAccessControlProfileResponse())},
    {IdentityCmdsId::WICbeginAddEntry,
     NosCmd(IdentityCmdsId::WICbeginAddEntry, string("WICbeginAddEntry"),
            new nugget::app::identity::WICbeginAddEntryRequest(),
            new nugget::app::identity::WICbeginAddEntryResponse())},
    {IdentityCmdsId::WICaddEntryValue,
     NosCmd(IdentityCmdsId::WICaddEntryValue, string("WICaddEntryValue"),
            new nugget::app::identity::WICaddEntryValueRequest(),
            new nugget::app::identity::WICaddEntryValueResponse())},
    {IdentityCmdsId::WICfinishAddingEntries,
     NosCmd(IdentityCmdsId::WICfinishAddingEntries,
            string("WICfinishAddingEntries"),
            new nugget::app::identity::WICfinishAddingEntriesRequest(),
            new nugget::app::identity::WICfinishAddingEntriesResponse())},
    {IdentityCmdsId::ICinitialize,
     NosCmd(IdentityCmdsId::ICinitialize, string("ICinitialize"),
            new nugget::app::identity::ICinitializeRequest(),
            new nugget::app::identity::ICinitializeResponse())},
    {IdentityCmdsId::ICcreateEphemeralKeyPair,
     NosCmd(IdentityCmdsId::ICcreateEphemeralKeyPair,
            string("ICcreateEphemeralKeyPair"),
            new nugget::app::identity::ICcreateEphemeralKeyPairRequest(),
            new nugget::app::identity::ICcreateEphemeralKeyPairResponse())},
    {IdentityCmdsId::ICgenerateSigningKeyPair,
     NosCmd(IdentityCmdsId::ICgenerateSigningKeyPair,
            string("ICgenerateSigningKeyPair"),
            new nugget::app::identity::ICgenerateSigningKeyPairRequest(),
            new nugget::app::identity::ICgenerateSigningKeyPairResponse())},
    {IdentityCmdsId::ICcreateAuthChallenge,
     NosCmd(IdentityCmdsId::ICcreateAuthChallenge,
            string("ICcreateAuthChallenge"),
            new nugget::app::identity::ICcreateAuthChallengeRequest(),
            new nugget::app::identity::ICcreateAuthChallengeResponse())},
    {IdentityCmdsId::ICstartRetrieveEntries,
     NosCmd(IdentityCmdsId::ICstartRetrieveEntries,
            string("ICstartRetrieveEntries"),
            new nugget::app::identity::ICstartRetrieveEntriesRequest(),
            new nugget::app::identity::ICstartRetrieveEntriesResponse())},
    {IdentityCmdsId::ICsetAuthToken,
     NosCmd(IdentityCmdsId::ICsetAuthToken, string("ICsetAuthToken"),
            new nugget::app::identity::ICsetAuthTokenRequest(),
            new nugget::app::identity::ICsetAuthTokenResponse())},
    {IdentityCmdsId::ICpushReaderCert,
     NosCmd(IdentityCmdsId::ICpushReaderCert, string("ICpushReaderCert"),
            new nugget::app::identity::ICpushReaderCertRequest(),
            new nugget::app::identity::ICpushReaderCertResponse())},
    {IdentityCmdsId::ICvalidateAccessControlProfile,
     NosCmd(
         IdentityCmdsId::ICvalidateAccessControlProfile,
         string("ICvalidateAccessControlProfile"),
         new nugget::app::identity::ICvalidateAccessControlProfileRequest(),
         new nugget::app::identity::ICvalidateAccessControlProfileResponse())},
    {IdentityCmdsId::ICvalidateRequestMessage,
     NosCmd(IdentityCmdsId::ICvalidateRequestMessage,
            string("ICvalidateRequestMessage"),
            new nugget::app::identity::ICvalidateRequestMessageRequest(),
            new nugget::app::identity::ICvalidateRequestMessageResponse())},
    {IdentityCmdsId::ICcalcMacKey,
     NosCmd(IdentityCmdsId::ICcalcMacKey, string("ICcalcMacKey"),
            new nugget::app::identity::ICcalcMacKeyRequest(),
            new nugget::app::identity::ICcalcMacKeyResponse())},
    {IdentityCmdsId::ICstartRetrieveEntryValue,
     NosCmd(IdentityCmdsId::ICstartRetrieveEntryValue,
            string("ICstartRetrieveEntryValue"),
            new nugget::app::identity::ICstartRetrieveEntryValueRequest(),
            new nugget::app::identity::ICstartRetrieveEntryValueResponse())},
    {IdentityCmdsId::ICretrieveEntryValue,
     NosCmd(IdentityCmdsId::ICretrieveEntryValue,
            string("ICretrieveEntryValue"),
            new nugget::app::identity::ICretrieveEntryValueRequest(),
            new nugget::app::identity::ICretrieveEntryValueResponse())},
    {IdentityCmdsId::ICfinishRetrieval,
     NosCmd(IdentityCmdsId::ICfinishRetrieval, string("ICfinishRetrieval"),
            new nugget::app::identity::ICfinishRetrievalRequest(),
            new nugget::app::identity::ICfinishRetrievalResponse())},
    {IdentityCmdsId::ICdeleteCredential,
     NosCmd(IdentityCmdsId::ICdeleteCredential, string("ICdeleteCredential"),
            new nugget::app::identity::ICdeleteCredentialRequest(),
            new nugget::app::identity::ICdeleteCredentialResponse())}};

/* Global declaration */

inline const std::map<int, NosApp> g_nosAppsMap = {
    // main array containing protobuf definition
    {App::AVB, NosApp(App::AVB, string("AVB"), avbCmds)},
    {App::Keymaster,
     NosApp(App::Keymaster, string("Keymaster"), keymasterCmds)},
    {App::Weaver, NosApp(App::Weaver, string("Weaver"), weaverCmds)},
    {App::Identity, NosApp(App::Identity, string("Identity"), identityCmds)},
};
}  // namespace nostypes

#endif  // NOSTYPE_H
