# Glass Cage: Zero-Click PNG Exploit Chain for iOS 18.2.1

- **CVE-2025-43300:** O.o.B Wrrite in ImageIO 
- **CVE-2025-24201:** WebKit Remote Code Execution 
- **CVE-2025-24085:** Core Media Privilege Escalation

**Patched:** Jan-March 2025  
**Tested On:** iPhone 14 Pro Max (iOS 18.2.1)  

[VirusTotal Analysis (Verified Hash)
](https://www.virustotal.com/gui/file/f1af3b4fd9f3f08253af21e4df4ea6bb35a135df0805d176238f26de80e8d167)

---

## Summary

**Glass Cage** is a critical, zero-click PNG-based exploit chain discovered **in the wild** targeting iOS 18.2.1. The attack was actively observed on a compromised device and confirmed to be used against real-world targets prior to vendor patching.

A malicious PNG image sent via iMessage initiates the chain by triggering automatic parsing in `MessagesBlastDoorService` (CVE-2025-43300). The image exploits a WebKit heap corruption vulnerability (CVE-2025-24201), followed by a sandbox escape and a kernel-level privilege escalation in Core Media (CVE-2025-24085).

The chain ultimately provides attackers with root-level access, persistent control, keychain exfiltration, and even the ability to irreversibly brick devices via IORegistry manipulation. No user interaction is required.

## Log Evidence: 

https://ia600508.us.archive.org/8/items/cve-2025-24085-24201/cve%202025-24085%3B%2024201.mov

---

## Exploit Chain

1. **Malicious PNG Creation**  
   - Embedded HEIF payloads with malformed EXIF fields  
   - Triggers heap corruption in `ATXEncoder` (CVE-2025-43300)
2. **Silent Trigger via iMessage**  
   - File auto-processed by `MessagesBlastDoorService` 
   - RCE achieved through WebKit (CVE-2025-24201)

3. **Sandbox Escape**  
   - WebKit bypasses resource isolation to access private assets

4. **Privilege Escalation**  
   - Core Media flaw enables kernel access  
   - Exploits `mediaplaybackd`, `codecctl`, and `IOHIDInterface` (CVE-2025-24085) 
5. **Persistence and Bricking**  
   - Injects rogue daemons via `launchd`  
   - Hijacks network through `wifid`  
   - Bricks device via IORegistry modification

---

## Indicators of Compromise

- WebKit resource lookups for internal assets  
- Rogue IP assignment: `172.16.101.176`  
- Modified proxy settings in `wifid`  
- Abnormal access to `CloudKeychainProxy`  
- IORegistry value: `IOAccessoryPowerSourceItemBrickLimit = 0`

---

## Timeline

| Date         | Event                                           |
|--------------|-------------------------------------------------|
| Dec 18, 2024 | Exploit chain observed in the wild & reported   |
| Jan 9, 2025  | Initial report re-submitted to US Cert & Apple  |
| Feb 20, 2025 | CVE-2025-24085 patched (Core Media)             |
| Mar 11, 2025 | CVE-2025-24201 patched (WebKit)                 |
| Mar 18, 2025 | CNVD-2025-06744 registered                      |
| Apr 22, 2025 | CNVD-2025-07885 registered                      |

---

## Disclosure

This exploit chain was discovered being used in the wild and responsibly disclosed to Apple. Patches have since been released. At the time of discovery, active exploitation was confirmed.

---

## CNVD Certification

This research has been independently verified and certified by the **China National Vulnerability Database (CNVD)**. These official certificates confirm the high-risk status of both vulnerabilities used in the Glass Cage exploit chain:

- **CNVD-2025-07885** – Use-After-Free in Apple Media Services  

- **CNVD-2025-06744** – Buffer Overflow in Apple iOS/iPadOS Core Media  
 
**Researcher:** Joseph Goydish  II
**Submission Type:** Personal Researcher Submission  
**Certification Authority:** CNCERT / CNVD  

---

## Why This Matters

iMessage creates a thumbnail and incoming-text alert as soon as a message is delivered, and that thumbnail is parsed automatically. If that parsing can be weaponized, mere delivery (thumbnail + alert) is enough for instant, silent compromise — no user action, no warning.


---

## References

- CVE-2025-24085 – Core Media Privilege Escalation  
- CVE-2025-24201 – WebKit Remote Code Execution  
- CNVD-2025-06744 – iOS/iPadOS Buffer Overflow  
- CNVD-2025-07885 – Use-After-Free in Apple Media Services  

---
